import java.rmi.*;
/**
 * Classe che implementa l'interfaccia INewsgroupClient
 * @author Letizia Cheng Cheng Sun
 * @version 1.0
 *
 */
public class NewsgroupClientImpl extends java.rmi.server.UnicastRemoteObject 
								implements INewsgroupClient{
	protected Person client;
	protected IShowMessage show;
	protected Msg[] mess;
	
	/**
	 * Costruttore che riceve in ingresso il cliente associato alla classe
	 * @param p dati cliente, istanza della classe Person
	 * @param s istanza di una classe che implementa l'interfaccia IShowMessage 
	 * @see IShowMessage
	 */
	public NewsgroupClientImpl(Person p,IShowMessage s)throws RemoteException{
		client=p;
		show=s;
		mess=null;
	}
	
	/**
	 * Metodo che restituisce la persona associata alla classe
	 * @return dati del cliente, istanza della classe Person
	 */
	public Person who()throws RemoteException{
		return client;
	}
	
	/**
	 * Metodo che implementa la callback con argomento un array di messaggi
	 * Il metodo stampa sul dispositivo d'uscita IShowMessage, i messaggi 
	 * ricevuti dal server attraverso callback
	 * @param m array di messaggi ricevuti dal server
	 */
	public void callback(Msg []m)throws RemoteException{
		if(m!=null){
			this.mess=m;
			int numMsg=m.length;
			for(int i=0;i<numMsg;i++){
				show.println("****************************************");
				show.println(m[i]);
				show.println("****************************************");
				show.println();
			}
		}
		else
			show.println("Non ci sono messaggi");
		
	}
	
	/**
	 * Metodo che implementa la callback con argomento un messaggio
	 * Il metodo stampa sul dispositivo d'uscita IShowMessage, il messaggio 
	 * ricevuto dal server attraverso callback
	 * @param m  messaggi ricevuto dal server
	 */
	public void callback(Msg mess)throws RemoteException{
		if(mess!=null){
			this.mess=new Msg[1];
			this.mess[0]=mess;
			show.println(mess+"\n");
		}
		else
			show.println("Il messaggio non  stato trovato");
		
	}
	
	/**
	 * Metodo che implementa la callback con argomento una stringa
	 * Il metodo stampa sul dispositivo d'uscita IShowMessage, la stringa 
	 * ricevuta dal server attraverso callback
	 * @param m stringa ricevuta dal server
	 */
	public void callback(String s)throws RemoteException{
		if(s!=null)
			show.println(s);
		else
			show.println("Errore nella callback");
	}
	
	/**
	 * Metodo che ritorna i messaggi ricevuti dal server
	 * @return array di messaggi
	 */
	public Msg[] getMsgs()throws RemoteException{
		return mess;
	}
}
